package jp.rutles.puzzle;

import java.util.*;

import android.graphics.*;

public class PuzzleBoard {
	public static final int CENTER = 0;	// ړl
	public static final int NORTH = 1;	// ړl
	public static final int SOUTH = 2;	// ړl
	public static final int EAST = 3;	// ړl
	public static final int WEST = 4;	// ړl
	private Bitmap image;	// \C[W
	private int[] data;	// \ꏊf[^Ǘz
	public int place;	// ݂̋󂫃Xy[Xʒu
	private static final int row = 6;	// s[X̏č
	private static final int col = 4;	// s[X̉̌
	private float x,y; // C
	private float pW = 100f; // C
	private float pH = 100f; // C
	public int count = 0;	// 
	
	public PuzzleBoard(float x, float y, float dw, float dh, Bitmap image) {
		super();
		this.x = x;
		this.y = y;
		pW *= dw;
		pH *= dh;

		this.image = image;
		data = new int[]{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,-1};
		place = 23;
	}

	public void init() {
		for (int i = 0;i < 200;i++){
			Random r = new Random(new Date().getTime());
			int a = r.nextInt(data.length);
			int b = r.nextInt(data.length);
			int val = data[a];
			data[a] = data[b];
			data[b] = val;
		}
		for (int i = 0;i < data.length;i++)
			if (data[i] == -1) place = i;
		count = 0;
	}
	
	public void draw(Canvas canvas){
		int n = 0;
		for (int i = 0;i < row;i++){
			for (int j = 0;j < col;j++){
				int c = data[n] % col;
				int r = (int)(data[n] / col);
				if (data[n] != -1){
					canvas.drawBitmap(image,
						new Rect((int)(x + c * pW), (int)(y + r * pH),
								(int)(x + c * pW + pW), (int)(y + r * pH + pH)),
						new Rect((int)(x + j * pW), (int)(y + i * pH),
								(int)(x + j * pW + pW), (int)(y + i * pH + pH)),
						new Paint());
				}
				n++;
			}
		}
	}
	
	public void move(int move){
		int c = place % col;
		int r = (int)(place / col);
		int c2 = c;
		int r2 = r;
		switch(move){
		case NORTH:
			if (r2 < row - 1) r2++;
			break;
		case SOUTH:
			if (r2 > 0) r2--;
			break;
		case WEST:
			if (c2 < col - 1) c2++;
			break;
		case EAST:
			if (c2 > 0) c2--; 
			break;
		}
		int n = data[r * col + c];
		data[r * col + c] = data[r2 * col + c2];
		data[r2 * col + c2] = n;
		for (int i = 0;i < data.length;i++)
			if (data[i] == -1) place = i;
		count++;
	}
	
	public boolean checkFinish(){
		boolean flg = true;
		for (int i = 0;i < data.length - 1;i++)
			if (data[i] != i) flg = false;
		return flg;
	}
}
