package jp.rutles.puzzle2;

import java.util.*;

import android.content.Context;
import android.graphics.*;

public class PuzzleBoard {
	private static final int ROW = 6;
	private static final int COL = 4;
	private float w = 400;
	private float h = 600;
	private float pW = 100;
	private float pH = 100;
	private float x, y;
	private PuzzlePiece[][] data;
	public PuzzlePiece dragPiece;
	public int count = 0;

	public PuzzleBoard(float x, float y, float w, float h, 
			Bitmap image, Context context) {
		super();
		this.x = x;
		this.y = y;
		this.w = w;
		this.h = h;
		pW = w / COL;
		pH = h / ROW;
		data = new PuzzlePiece[COL][ROW];
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				Bitmap bitmap = Bitmap.createBitmap(image, (int) (pW * i),
						(int) (pH * j), (int) pW, (int) pH);
				data[i][j] = new PuzzlePiece(bitmap, i, j, pW, pH, context);
				data[i][j]
						.setLoc((int) (x + pW * i), (int) (y + pH * j), false);
			}
		}
	}

	public void init() {
		Random r = new Random(new Date().getTime());
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				data[i][j].setLoc(r.nextInt((int) w), r.nextInt((int) h), true);
				data[i][j].placed = false;
			}
		}
		count = 0;
	}

	public void draw(Canvas c) {
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				if (data[i][j] != null)
					data[i][j].draw(c);
			}
		}
	}

	public PuzzlePiece getIn(int x, int y) {
		PuzzlePiece result = null;
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				if (data[i][j].isIn(x, y))
					result = data[i][j];
			}
		}
		return result;
	}

	public void dragPiece(int x0, int y0) {
		if (dragPiece != null) {
			int px = dragPiece.getPlaceX();
			int py = dragPiece.getPlaceY();
			if (!data[px][py].placed)
				dragPiece.setLoc(x0, y0, true);
		}
	}

	public void checkPlace() {
		if (dragPiece != null) {
			int px = dragPiece.getPlaceX();
			int py = dragPiece.getPlaceY();
			Rect r = dragPiece.getRect();
			if (Math.abs(x + px * pW - r.left) < (pW / 4)
					&& Math.abs(y + py * pH - r.top) < (pH / 4)) {
				dragPiece.setLoc((int) (x + px * pW), (int) (y + py * pH),
						false);
				data[px][py].placed = true;
			}
		}
	}

	public boolean checkFinish() {
		boolean flg = true;
		for (int i = 0; i < COL; i++)
			for (int j = 0; j < ROW; j++)
				if (data[i][j].placed == false)
					flg = false;
		return flg;
	}

}
