package jp.rutles.puzzle2;

import android.content.Context;
import android.graphics.*;
import android.graphics.drawable.BitmapDrawable;

public class PuzzlePiece {
	private BitmapDrawable image;
	private float width, height, x, y, x1, y1, x2, y2;
	private int placeX, placeY;
	public boolean placed;

	public PuzzlePiece(Bitmap image, int x, int y, float w, float h,
			Context context) {
		super();
		this.image = new BitmapDrawable(context.getResources(), image);
		placeX = x;
		placeY = y;
		width = w;
		height = h;
		placed = false;
	}

	public void setLoc(int x, int y, boolean center) {
		if (center) {
			this.x = x;
			this.y = y;
			x1 = this.x - (width / 2);
			y1 = this.y - (height / 2);
		} else {
			this.x = x + (width / 2);
			this.y = y + (height / 2);
			x1 = x;
			y1 = y;
		}
		x2 = x1 + width;
		y2 = y1 + height;
	}

	public int getPlaceX() {
		return placeX;
	}

	public int getPlaceY() {
		return placeY;
	}

	public Rect getRect() {
		return new Rect((int) x1, (int) y1, (int) x2, (int) y2);
	}

	public boolean isIn(int x, int y) {
		return x > x1 && x < x2 && y > y1 && y < y2;
	}

	public void draw(Canvas c) {
		image.setBounds((int) x1, (int) y1, (int) x2, (int) y2);
		image.draw(c);
	}

}
