package jp.rutles.puzzle2;

import java.util.*;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.*;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.*;
import android.widget.Toast;

public class PuzzleView extends View {
	private int btn_x = 47;
	private int btn_y = 768;
	private int btn_w = 390;
	private int btn_h = 40;
	private int board_x = 40;
	private int board_y = 126;
	private float board_w = 400;
	private float board_h = 600;
	private int score_x = 60;
	private int score_y = 73;

	private Puzzle puzzle;
	private PuzzleBoard board;
	private Drawable back, btn1, btn2;
	private boolean btn_down, isPlaying;
	private int pressX, pressY;
	private String message = "please touch button.";
	private Timer timer;

	public PuzzleView(Context context) {
		super(context);
		init(context);
	}

	public PuzzleView(Context context, AttributeSet attrs) {
		super(context, attrs);
		init(context);
	}

	private void init(Context context) {
		puzzle = (Puzzle) context;
		btn_down = false;
		isPlaying = false;
		setPuzzleSize(context);
	}

	private void setPuzzleSize(Context context) {
		float w = puzzle.disp_w;
		float h = puzzle.disp_h;
		float dw = w / 480f;
		float dh = h / 854f;

		btn_x *= dw;
		btn_y *= dh;
		btn_w *= dw;
		btn_h *= dh;
		board_x *= dw;
		board_y *= dh;
		board_w *= dw;
		board_h *= dh;
		score_x *= dw;
		score_y *= dh;

		Resources resources = puzzle.getResources();
		back = resources.getDrawable(R.drawable.back);
		back.setBounds(0, 0, (int) w, (int) h);
		btn1 = resources.getDrawable(R.drawable.start);
		btn1.setBounds(btn_x, btn_y, btn_x + btn_w, btn_y + btn_h);
		btn2 = resources.getDrawable(R.drawable.start2);
		btn2.setBounds(btn_x, btn_y, btn_x + btn_w, btn_y + btn_h);

		Bitmap img = BitmapFactory.decodeResource(resources, R.drawable.image1);
		board = new PuzzleBoard(board_x, board_y, board_w, board_h, img,
				context);
	}

	@Override
	protected void onDraw(Canvas c) {
		c.drawColor(Color.BLACK);
		back.draw(c);
		board.draw(c);
		if (btn_down) {
			btn2.draw(c);
		} else {
			btn1.draw(c);
		}
		Paint p = new Paint();
		p.setTextSize(30f);
		c.drawText(message, score_x, score_y, p);
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		int action = event.getAction();
		int x = (int) event.getX();
		int y = (int) event.getY();
		switch (action) {
		case MotionEvent.ACTION_DOWN:
			pressX = x;
			pressY = y;
			if (isPlaying) {
				board.dragPiece = board.getIn(pressX, pressY);
			} else {
				if (isIn(pressX, pressY, btn1.getBounds())) {
					btn_down = true;
				}
			}
			break;
		case MotionEvent.ACTION_UP:
			if (isPlaying) {
				board.checkPlace();
				if (board.checkFinish()) {
					timer.cancel();
					Toast toast = Toast.makeText(puzzle, "NAI",
							Toast.LENGTH_LONG);
					toast.show();
					isPlaying = false;
				}
			} else {
				if (isIn(pressX, pressY, btn1.getBounds())) {
					btn_down = false;
					isPlaying = true;
					board.init();
					startTimer();
					Toast toast = Toast.makeText(puzzle, "X^[gI",
							Toast.LENGTH_LONG);
					toast.show();
				}
			}
			btn_down = false;
			board.dragPiece = null;
			break;
		case MotionEvent.ACTION_MOVE:
			if (isPlaying) {
				board.dragPiece(x, y);
			}
			break;
		}
		invalidate();
		return true;
	}

	public boolean isIn(int x, int y, Rect rect) {
		return x > rect.left && x < rect.right && y > rect.top
				&& y < rect.bottom;
	}

	public void startTimer() {
		final Handler handler = new Handler();
		TimerTask task = new TimerTask() {
			private int count = 0;

			@Override
			public void run() {
				message = "Time: " + ++count + " sec.";

				handler.post(new Runnable() {

					@Override
					public void run() {
						invalidate();
					}
				});
			}
		};
		timer = new Timer();
		timer.schedule(task, 0, 1000);
	}

}
