package jp.rutles.reversi;

import android.graphics.*;
import android.graphics.drawable.Drawable;

public class ReversiBoard {
	private static final int ROW = 8;
	private static final int COL = 8;
	private Drawable black, white;
	private ReversiObject object;
	private float pW = 50;
	private float pH = 50;
	private float x, y;
	public int you = 1;
	public int comp = 2;
	public String[] messages;
	public boolean isPlaying, canMove;

	public ReversiBoard(float x, float y, float w, float h, Drawable black,
			Drawable white) {
		super();
		this.x = x;
		this.y = y;
		pW = w / COL;
		pH = h / ROW;
		isPlaying = false;
		canMove = false;
		this.black = black;
		this.white = white;
		object = new ReversiObject();
		messages = new String[] { "", "", "", "", "", "" };
	}

	public void start() {
		object.init();
		isPlaying = true;
		messages = new String[] { "", "", "", "", "", "" };
		if (comp == 1) {
			canMove = false;
		} else {
			canMove = true;
		}
	}

	public void changeSide() {
		if (you == 1) {
			you = 2;
			comp = 1;
		} else {
			you = 1;
			comp = 2;
		}
	}

	public void addMessage(String s) {
		for (int i = messages.length - 2; i >= 0; i--)
			messages[i + 1] = messages[i];
		messages[0] = s;
	}

	public String getScore() {
		String s = "";
		if (you == 1) {
			s = "[Ȃ]:" + object.black_num + "    [Android]:"
					+ object.white_num;
		} else {
			s = "[Android]:" + object.black_num + "    [Ȃ]:"
					+ object.white_num;
		}
		return s;
	}

	public void draw(Canvas c) {
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				float x1 = x + pW * i;
				float y1 = y + pH * j;
				float x2 = x1 + pW;
				float y2 = y1 + pH;
				Rect r = new Rect((int) x1, (int) y1, (int) x2, (int) y2);
				switch (object.data[i][j]) {
				case 0:
					break;
				case 1:
					black.setBounds(r);
					black.draw(c);
					break;
				case 2:
					white.setBounds(r);
					white.draw(c);
					break;
				}
			}
		}
	}

	public boolean pressHere(int x0, int y0) {
		int c = (int) ((x0 - x) / pW);
		int r = (int) ((y0 - y) / pH);
		if (c < 0 || c >= COL || r < 0 || r >= ROW) {
			return false;
		}
		if (object.data[c][r] != 0)
			return false;
		int n = object.getPieces(object.data, c, r, you);
		if (n <= 0) {
			return false;
		}
		object.setPiece(c, r, you);
		object.reversePieces(object.data, c, r, you);
		addMessage("Ȃ́A" + (c + 1) + "," + (r + 1) + "ɒu܂B");
		object.passflg[you] = false;
		if (object.checkFinish()) gameOver();
		return true;
	}

	public void doComp() {
		object.passflg[comp] = false;
		String s = object.comp(comp);
		addMessage(s);
		if (object.checkFinish()) {
			gameOver();
		}
	}

	public boolean isPass(int side) {
		return object.isPass(side);
	}

	public void gameOver() {
		String str1 = "";
		String bstr = "";
		String wstr = "";
		if (you == 1) {
			bstr = "Ȃ";
			wstr = "";
		} else {
			bstr = "";
			wstr = "Ȃ";
		}
		isPlaying = false;
		int black = object.black_num;
		int white = object.white_num;
		if (object.black_num == object.white_num)
			str1 = "łˁB";
		else if (object.black_num > object.white_num)
			str1 = bstr + "̏łI";
		else if (object.black_num < object.white_num)
			str1 = wstr + "̏łI";
		addMessage("**** GAME END. ****");
		addMessage(bstr + "F" + black + "@" + wstr + "F" + white);
		addMessage(str1);
	}
}
