package jp.rutles.reversi;

public class ReversiObject {
	private static final int ROW = 8;
	private static final int COL = 8;
	public int[][] data;
	public boolean[] passflg;
	public int black_num, white_num;

	public ReversiObject() {
		super();
		data = new int[COL][ROW];
		passflg = new boolean[3];
		init();
	}

	public void init() {
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				data[i][j] = 0;
			}
		}
		data[3][3] = 1;
		data[3][4] = 2;
		data[4][3] = 2;
		data[4][4] = 1;
	}

	public void setPiece(int c, int r, int side) {
		data[c][r] = side;
	}
	
	public int[][] createDataCopy(int[][] data2){
		int [][] result = new int[COL][ROW];
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				result[i][j] = data2[i][j];
			}
		}
		return result;
	}

	public String comp(int side) {
		String msg = "";
		if (isPass(side)) {
			msg = "́ApX܂B";
		} else {
			int[] n = getMax(data,side,true);
			passflg[side] = false;
			data[n[0]][n[1]] = side;
			data = reversePieces(data, n[0], n[1], side);
			msg = "́A" + (n[0] + 1) + "," + (n[1] + 1) + "Ƃ܂B";
		}
		return msg;
	}

	public int[] getMax(int[][] data2, int side,boolean flg) {
		int x = -1;
		int y = -1;
		int getn = 0;
		int nn = -10000;
		int[][] bkdata = createDataCopy(data2);
		for (int i = 0; i < 8; i++) {
			for (int j = 0; j < 8; j++) {
				if (bkdata[i][j] == 0) {
					int n0 = getPieces(bkdata, i, j, side);
					getn += n0;
					if (n0 == 0) {
						//bkdata = createDataCopy(data2);
						continue;
					}
					if (n0 > 0) {
						if ((i == 0) || (i == 7))
							n0 += 10;
						if ((j == 0) || (j == 7))
							n0 += 10;
						if (((i == 0) || (i == 7)) && ((j == 0) || (j == 7)))
							n0 += 1000;
						if (((i == 1) || (i == 6)) && ((j == 1) || (j == 6)))
							n0 -= 100;
						if (((i == 0) || (i == 7)) && ((j == 1) || (j == 6)))
							n0 = n0 - 5;
						if (((i == 1) || (i == 6)) && ((j == 0) || (j == 7)))
							n0 = n0 - 5;
						bkdata[i][j] = side;
						bkdata = reversePieces(bkdata, i, j, side);
						int n1 = 0;
						if (flg){
							int[] narr = getMax(bkdata, side % 2 + 1,false);
							n1 = (int) (narr[side] * 3.001);
						}
						bkdata = createDataCopy(data2);
						if ((n0 - n1) > nn) {
							nn = n0 - n1;
							x = i;
							y = j;
						}
					}
				}
			}
		}
		return new int[] { x, y, getn };
	}

	public int getPieces(int[][] data0, int x1, int y1, int side) {
		int num = 0;
		int[] dt = { 0, -1, 1 };
		for (int dx : dt) {
			for (int dy : dt) {
				int xn = x1;
				int yn = y1;
				boolean f = false;
				int nn = 0;
				while (true) {
					xn += dx;
					yn += dy;
					f = true;
					if ((xn == x1) && (yn == y1)){
						f = false;
						break;
					}
					if ((xn < 0) || (xn > 7) || (yn < 0) || (yn > 7)) {
						f = false;
						break;
					}
					if (data0[xn][yn] == 0) {
						f = false;
						break;
					}
					if (data0[xn][yn] == side) {
						f = true;
						break;
					}
					++nn;
					if ((xn == 0) || (xn == 7))
						nn += 10;
					if ((yn == 0) || (yn == 7))
						nn += 10;
				}
				if (f) num += nn;
			}
		}
		return num;
	}

	public int[][] reversePieces(int[][] data2, int x1, int y1, int side) {
		int[] dt = { 0, -1, 1 };
		for (int dx : dt) {
			for (int dy : dt) {
				int xn = x1;
				int yn = y1;
				boolean f = false;
				while (true) {
					xn = xn + dx;
					yn = yn + dy;
					if ((xn < 0) || (xn > 7) || (yn < 0) || (yn > 7)) {
						f = false;
						break;
					}
					if (data2[xn][yn] == 0) {
						f = false;
						break;
					}
					if (data2[xn][yn] == side)
						break;
					f = true;
				}
				if (f) {
					xn = x1;
					yn = y1;
					while (true) {
						xn = xn + dx;
						yn = yn + dy;
						if (data2[xn][yn] == side)
							break;
						data2[xn][yn] = side;
					}
				}
			}
		}
		return data2;
	}

	public boolean isPass(int side){
		int[] n = getMax(data, side, false);
		if (n[2] == 0){
			passflg[side] = true;
			return true;
		} else {
			return false;
		}
	}

	public void countData(){
		black_num = 0;
		white_num = 0;
		for(int i = 0;i < 8;i++){
			for(int j = 0;j < 8;j++){
				if (data[i][j] == 1) black_num++;
				if (data[i][j] == 2) white_num++;
			}
		}
	}

	public boolean checkFinish() {
		countData();
		if (black_num + white_num == COL * ROW)
			return true;
		if ( passflg[1] && passflg[2])
			return true;
		return false;
	}
}
