package jp.rutles.reversi;

import java.util.*;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.*;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.*;
import android.widget.Toast;

public class ReversiView extends View {
	private int board_x = 41;
	private int board_y = 149;
	private float board_w = 400;
	private float board_h = 400;
	private int score_x = 60;
	private int score_y = 83;
	private int msg_x = 50;
	private int msg_y = 647;
	private Timer timer;
	
	private Reversi reversi;
	private ReversiBoard board;
	private Drawable back, black, white;

	public ReversiView(Context context) {
		super(context);
		init(context);
	}
	
	public ReversiView(Context context, AttributeSet attrs) {
		super(context, attrs);
		init(context);
	}
	
	private void init(Context context) {
		reversi = (Reversi) context;
		setBoardSize();
	}
	
	private void setBoardSize() {
		float w = reversi.disp_w;
		float h = reversi.disp_h;
		float dw = w / 480f;
		float dh = h / 854f;

		board_x *= dw;
		board_y *= dh;
		board_w *= dw;
		board_h *= dh;
		score_x *= dw;
		score_y *= dh;
		msg_x *= dw;
		msg_y *= dh;

		Resources resources = reversi.getResources();
		back = resources.getDrawable(R.drawable.back);
		back.setBounds(0, 0, (int) w, (int) h);
		black = resources.getDrawable(R.drawable.black);
		white = resources.getDrawable(R.drawable.white);
		board = new ReversiBoard(board_x, board_y, board_w, board_h, black,
				white);
	}
	
	public void start() {
		showMsg("vCJnłB");
		board.start();
		if (board.comp == 1){
			startTimer();
		}
		invalidate();
	}
	
	public void changeSide() {
		board.changeSide();
		String msg = "TCh܂B\n";
		if (board.you == 1){
			msg += "ȂAłB";
		} else {
			msg += "AłB";
		}
		invalidate();
		showMsg(msg);
	}
	
	public void showMsg(String s){
		Toast toast = Toast.makeText(reversi, s, Toast.LENGTH_SHORT);
		toast.show();
	}

	@Override
	protected void onDraw(Canvas c) {
		c.drawColor(Color.BLACK);
		back.draw(c);
		board.draw(c);
		Paint p = new Paint();
		p.setTextSize(20f);
		c.drawText(board.getScore(), score_x, score_y, p);
		for (int i = 0; i < board.messages.length;i++)
			c.drawText(board.messages[i], msg_x, msg_y + 30 * i, p);
	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
		int action = event.getAction();
		int x = (int) event.getX();
		int y = (int) event.getY();
		switch (action) {
		case MotionEvent.ACTION_DOWN:
			board.canMove = false;
			if (board.isPlaying){
				boolean f = board.pressHere(x, y);
				invalidate();
				if (board.isPlaying){
					if (f)
						startTimer();
					else
						showMsg("ɂ͒u܂I");
				}
			}
			break;
		case MotionEvent.ACTION_UP:
			break;
		case MotionEvent.ACTION_MOVE:
			break;
		}
		invalidate();
		return true;
	}

	public boolean isIn(int x, int y, Rect rect) {
		return x > rect.left && x < rect.right && y > rect.top
				&& y < rect.bottom;
	}

	public void startTimer(){
		final Handler handler = new Handler();
		TimerTask task = new TimerTask(){
			
			@Override
			public void run() {
				handler.post(new Runnable(){

					@Override
					public void run() {
						board.doComp();
						invalidate();
						timer.cancel();
						if (!board.isPlaying) return;
						if (board.isPass(board.you)){
							board.addMessage("Ȃ́ApXłB");
							showMsg("Ȃ́ApXłB");
							startTimer();
						} else {
							board.canMove = true;
						}
					}
				});
			}
		};
		timer = new Timer();
		timer.schedule(task, 1000);
	}
}
