package jp.rutles.rolling;

import android.graphics.*;
import android.os.SystemClock;

public class Ball {
	private float x = 0;
	private float y = 0;
	private float w = 30;
	private float h = 30;
	private float dx, dy;
	public boolean show_flg;
	private long last_time;
	
	public Ball(float x, float y){
		this.x = x;
		this.y = y;
		init();
	}
	
	public void init(){
		show_flg = true;
		dx = 1.0f;
		dy = 1.0f;
	}
	
	public void move(float dx, float dy){
		x -= dx * this.dx;
		y -= dy * this.dy;
		if (SystemClock.currentThreadTimeMillis() > last_time)
			show_flg = true;
	}
	
	public void setPoint(float x, float y){
		this.x = x;
		this.y = y;
	}

	public Rect getBounds(){
		return new Rect(
			(int)x, (int)y, (int)(x + w), (int)(y + h)
		);
	}
	
	public Point getContactPoint(){
		return new Point((int)(x + (w / 2)),(int)(y + h - 5));
	}
	
	public void invisibled(long time){
		last_time = SystemClock.currentThreadTimeMillis() + time;
		show_flg = false;
	}
	
	public void sensitived(float fx, float fy){
		dx *= fx;
		dy *= fy;
	}
}
