package jp.rutles.rolling;

import android.graphics.Point;

public class Piece {
	public static int GOAL = 2;
	private float x,y;
	private int ground;
	private int event;
	private float w = 50f;
	
	public Piece(float x, float y, int g, int e){
		this.x = x;
		this.y = y;
		this.ground = g;
		this.event = e;
	}

	public int getGround() {
		return ground;
	}

	public int getEvent() {
		return event;
	}
	
	public Point getPoint(){
		return new Point((int)x, (int)y);
	}
	
	public void hideEvent(){
		event = 0;
	}
	
	public boolean isOnPiece(Point p){
		boolean flg = false;
		switch(ground){
		case 0:
			flg = false;
			break;
		case 1:
			flg = p.x + p.y < w ? true : false;
			break;
		case 2:
			flg = p.x > p.y ? true : false;
			break;
		case 3:
			flg = p.x + p.y > w ? true : false;
			break;
		case 4:
			flg = p.x < p.y ? true : false;
			break;
		case 5:
			flg = p.x + p.y > w ? true : false;
			break;
		case 6:
			flg = p.x < p.y ? true : false;
			break;
		case 7:
			flg = p.x >= 0 && p.x <= w && p.y >= 0 && p.y <= w ? true : false;
			break;
		case 8:
			flg = false;
			break;
		}
		return flg;
	}
}
