package jp.rutles.rolling;

import android.content.res.Resources;
import android.graphics.*;
import android.graphics.Paint.Style;
import android.graphics.drawable.Drawable;

public class RollingBoard {
	private static final int ROW = 16; // {[h̏c̗vf
	private static final int COL = 9; // {[h̗̉vf
	private float board_x = 15; // {[h̉ʒu
	private float board_y = 15; // {[h̏cʒu
	private float piece_w = 50; // p[c̉
	private float piece_h = 50; // p[c̏c
	private float start_col = 5; // X^[gn_̉ʒu
	private float start_row = 5; // X^[gn_̏cʒu
	private Ball ball; // BallCX^X
	private Piece[][] datas; // PiecêQz
	private Drawable[] ground_img, event_img; // nʂƃCxg̃OtBbN
	private Drawable ball_img; // {[̃OtBbN
	public boolean game_flg,goal_flg; // Q[ƃS[`FbN
	
	public RollingBoard(){
		init();
	}
	
	public void init(){
		loadData();
		ball.init();
		ball.setPoint(board_x + start_col * piece_w, board_y + start_row * piece_h);
		game_flg = true;
		goal_flg = false;
	}
	
	public void loadData(){
		datas = new Piece[ROW][COL];
		int[][] ground = new int[][]{
				{0,0,0,0,0,0,0,0,0},
				{0,7,7,7,6,0,0,0,0},
				{0,8,3,7,7,7,7,6,0},
				{0,5,7,7,1,2,7,7,0},
				{0,2,7,7,4,3,7,7,0},
				{0,8,2,7,7,7,7,1,0},
				{0,0,8,8,8,3,1,8,0},
				{0,0,0,0,3,7,4,0,0},
				{0,0,0,5,1,8,2,6,0},
				{0,0,5,7,4,0,8,7,0},
				{0,0,2,7,1,0,5,1,0},
				{0,0,8,2,4,5,1,8,0},
				{0,0,5,7,7,7,8,0,0},
				{0,3,7,1,8,7,7,6,0},
				{0,2,7,4,0,2,7,7,6},
				{0,8,2,7,7,7,7,7,1}
		};
		int[][] event = new int[][]{
				{0,0,0,0,0,0,0,0,0},
				{0,1,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,6,0,0,4,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,5,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,3,0,4,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,0,0,0,0,0,0,0,0},
				{0,5,0,0,0,0,0,0,0},
				{0,0,0,6,0,0,3,0,0},
				{0,0,0,0,0,0,0,2,0}
		};
		for (int i = 0;i < ROW;i++){
			for (int j = 0;j < COL;j++){
				int g = ground[i][j];
				int e = event[i][j];
				datas[i][j] = new Piece(board_x + piece_w * j,board_y + piece_h * i, g, e);
				if (event[i][j] == 1){
					start_col = j;
					start_row = i;
				}
			}
		}
		ball = new Ball(board_x + start_row * piece_w, board_y + start_col * piece_h);
	}
	
	public void loadImages(Resources resources){
		ground_img = new Drawable[9];
		ground_img[0] = resources.getDrawable(R.drawable.g01);
		ground_img[1] = resources.getDrawable(R.drawable.g02);
		ground_img[2] = resources.getDrawable(R.drawable.g03);
		ground_img[3] = resources.getDrawable(R.drawable.g04);
		ground_img[4] = resources.getDrawable(R.drawable.g05);
		ground_img[5] = resources.getDrawable(R.drawable.g06);
		ground_img[6] = resources.getDrawable(R.drawable.g07);
		ground_img[7] = resources.getDrawable(R.drawable.g08);
		ground_img[8] = resources.getDrawable(R.drawable.g09);
		
		event_img = new Drawable[7];
		event_img[0] = null; // No Event.
		event_img[1] = null; // Start Point.
		event_img[2] = resources.getDrawable(R.drawable.goal);
		event_img[3] = resources.getDrawable(R.drawable.warp);
		event_img[4] = resources.getDrawable(R.drawable.teki001);
		event_img[5] = resources.getDrawable(R.drawable.teki002);
		event_img[6] = resources.getDrawable(R.drawable.teki003);
		
		ball_img = resources.getDrawable(R.drawable.ball);
	}
	
	public float getStartX(){ return piece_w * start_col; }
	public float getStartY(){ return start_row; }
	
	public void move(float dx, float dy){
		ball.move(dx, dy);
	}
	
	public void draw(Canvas c){
		if (ground_img == null || event_img == null) return;
		for (int i = 0;i < ROW;i++){
			for (int j = 0;j < COL;j++){
				int g = datas[i][j].getGround();
				int e = datas[i][j].getEvent();
				Point p = datas[i][j].getPoint();
				Rect r = new Rect(p.x, p.y,
						(int)(p.x + piece_w), (int)(p.y + piece_h));
				ground_img[g].setBounds(r);
				ground_img[g].draw(c);
				if  (e > 1){
					event_img[e].setBounds(r);
					event_img[e].draw(c);
				}
			}
		}
		if (ball.show_flg){
			Paint pb = new Paint();
			pb.setColor(Color.argb(50, 0, 0, 0));
			pb.setStyle(Style.FILL);
			Point ptb = ball.getContactPoint();
			RectF rb = new RectF(ptb.x - 14, ptb.y - 10,ptb.x + 14, ptb.y + 10);
			c.drawArc(rb, 0, 360, false, pb);
			ball_img.setBounds(ball.getBounds());
			ball_img.draw(c);
		}
	}
	
	public Piece getOnBalledPiece(){
		Point p = ball.getContactPoint();
		int c = (int)((p.x - board_x) / piece_w);
		int r = (int)((p.y - board_y) / piece_h);
		if (c < 0 || c >= COL || r < 0 || r >= ROW)
			return null;
		else
			return datas[r][c];
	}
	
	public boolean isBallOnPiece(Piece piece){
		Point ball_p = ball.getContactPoint();
		Point piece_p = piece.getPoint();
		float dx = ball_p.x - piece_p.x;
		float dy = ball_p.y - piece_p.y;
		return piece.isOnPiece(new Point((int)dx, (int)dy));
	}
	
	public void doEvent(Piece piece){
		switch(piece.getEvent()){
		case 3:
			int x = (int)(board_x + start_col * piece_w);
			int y = (int)(board_y + start_row * piece_h);
			ball.setPoint(x, y);
			break;
		case 4:
			piece.hideEvent();
			ball.invisibled(1000);
			break;
		case 5:
			piece.hideEvent();
			ball.sensitived(3.0f, 1.0f);
			break;
		case 6:
			piece.hideEvent();
			ball.sensitived(1.0f, 3.0f);
			break;
		}
	}
}
