package jp.rutles.rolling;

import java.util.*;
import java.util.concurrent.*;

import android.app.Activity;
import android.content.Context;
import android.graphics.*;
import android.hardware.*;
import android.util.AttributeSet;
import android.view.*;
import android.widget.Toast;

public class RollingView extends SurfaceView
		implements SensorEventListener, SurfaceHolder.Callback {
	private ScheduledExecutorService executor; // XbhpCX^X
	private SurfaceHolder holder; // T[tFCX̃z_
	private Rolling rolling; // RollingNX
	private RollingBoard board; // RollingBoardNX
	private Piece last_piece; // ŌɃ{[Piece
	private float dx, dy; // ړ
	private float msg_x,msg_y; // bZ[W̕\ʒu
	private float score_x,score_y; // XRA̕\ʒu
	private long start_time = 0; // X^[g

	public RollingView(Context context) {
		super(context);
		init(context);
	}

	public RollingView(Context context, AttributeSet attrs) {
		super(context, attrs);
		init(context);
	}

	public void init(Context context) {
		msg_x = 100;
		msg_y = 200;
		score_x = 320;
		score_y = 50;
		start_time = Calendar.getInstance().getTimeInMillis();
		holder = getHolder();
		holder.addCallback(this);
		setFocusable(true);
		requestFocus();
		rolling = (Rolling)context;
		board = new RollingBoard();
		board.loadImages(rolling.getResources());

		SensorManager manager= (SensorManager)rolling.
				getSystemService(Activity.SENSOR_SERVICE);
		List<Sensor> sensors = manager.
				getSensorList(Sensor.TYPE_ACCELEROMETER);
		if (sensors.size() > 0) {
			Sensor sensor = sensors.get(0);
			manager.registerListener(this, sensor,
					SensorManager.SENSOR_DELAY_FASTEST);
		}
	}

	public void start() {
		try {
			executor.shutdown();
		} catch (Exception e) {}
		dx = 0;
		dy = 0;
		board.init();
		last_piece = null;
		start_time = Calendar.getInstance().getTimeInMillis();
		
		executor = Executors.newSingleThreadScheduledExecutor();
		executor.scheduleAtFixedRate(new Runnable() {
			@Override
			public void run() {
				board.move(dx,dy);
				draw();
				Piece piece = board.getOnBalledPiece();
				if (piece == null)
					finish(false);
				else {
					if (!board.isBallOnPiece(piece))
						finish(false);
					else if (piece.getEvent() == Piece.GOAL)
						finish(true);
					else if (last_piece != piece){
						last_piece = piece;
						board.doEvent(piece);
					}
				}
				if (board.goal_flg) finish(true);
				else if (!board.game_flg) finish(false);
			}
		}, 100, 100, TimeUnit.MILLISECONDS);
		showMsg("X^[gI");
	}

	public void draw(){
		Canvas canvas = holder.lockCanvas();
		canvas.drawColor(Color.RED);
		if (canvas != null){
			board.draw(canvas);
		}
		
		Paint p0 = new Paint();
		p0.setColor(Color.WHITE);
		p0.setTextSize(30);
		p0.setFakeBoldText(true);
		long t = Calendar.getInstance().
				getTimeInMillis() - start_time;
		canvas.drawText("TIME: " + (int)Math.
				floor(t / 1000), score_x, score_y, p0);
		
		if (!board.game_flg){
			Paint p = new Paint();
			p.setTextSize(50);
			p.setFakeBoldText(true);
			if (board.goal_flg){
				p.setColor(Color.RED);
				canvas.drawText("You Goal!!", msg_x, msg_y, p);
			} else {
				p.setColor(Color.GRAY);
				canvas.drawText("GAME OVER.", msg_x, msg_y, p);
			}
		}
		holder.unlockCanvasAndPost(canvas);
	}
	
	@Override
	public void surfaceCreated(SurfaceHolder holder) {
		draw();
	}

	@Override
	public void surfaceChanged(SurfaceHolder holder,
			int format, int width, int height) {}

	@Override
	public void surfaceDestroyed(SurfaceHolder holder) {
		try {
			executor.shutdown();
		} catch (Exception e) {}
	}

	@Override
	public void onAccuracyChanged(Sensor sensor,
			int accuracy) {}

	@Override
	public void onSensorChanged(SensorEvent event) {
		if (event.sensor.getType() == Sensor.TYPE_ACCELEROMETER) {
			dx += event.values[0] / 10;
			dy -= event.values[1] / 10;
		}
	}

	public void showMsg(String s) {
		Toast toast = Toast.makeText(rolling, s, Toast.LENGTH_SHORT);
		toast.show();
	}
	
	public void finish(boolean goal){
		executor.shutdown();
		board.game_flg = false;
		board.goal_flg = goal;
		draw();
	}
}
