package jp.rutles.simplereversi;

import android.graphics.*;
import android.graphics.drawable.Drawable;

public class ReversiBoard {
	private static final int ROW = 8;
	private static final int COL = 8;
	private Drawable black,white;
	private ReversiObject object;
	private float pW = 50;
	private float pH = 50;
	private float x,y;
	public int side;
	public boolean isPlaying;

	public ReversiBoard(float x, float y,float w, float h,
			Drawable black, Drawable white) {
		super();
		this.x = x;
		this.y = y;
		pW = w / COL;
		pH = h / ROW;
		isPlaying = false;
		this.black = black;
		this.white = white;
		object = new ReversiObject();
	}

	public void start() {
		isPlaying = true;
		side = 1;
		object.init();
		object.countData();
	}
	
	public void change() {
		side = side == 1 ? 2 : 1;
	}

	public String getScore(){
		return ":" + object.black_num + "    :" + object.white_num;
	}
	
	public void draw(Canvas c){
		for (int i = 0;i < COL;i++){
			for (int j = 0;j < ROW;j++){
				float x1 = x + pW * i;
				float y1 = y + pH * j;
				float x2 = x1 + pW;
				float y2 = y1 + pH;
				Rect r = new Rect((int)x1, (int)y1, (int)x2, (int)y2);
				switch (object.data[i][j]){
				case 0:
					break;
				case 1:
					black.setBounds(r);
					black.draw(c);
					break;
				case 2:
					white.setBounds(r);
					white.draw(c);
					break;
				}
			}
		}
	}

	public boolean pressHere(int x0, int y0){
		int c = (int)((x0 - x) / pW);
		int r = (int)((y0 - y) / pH);
		if (c < 0 || c >= COL || r < 0 || r >= ROW){
			return false;
		}
		if (object.data[c][r] != 0) return false;
		int n = object.getPieces(object.data, c, r, side);
		if (n <= 0){
			return false;
		}
		object.setPiece(c,r,side);
		object.reversePieces(object.data, c, r, side);
		object.countData();
		return true;
	}
}
