package jp.rutles.simplereversi;

public class ReversiObject {
	private static final int ROW = 8;
	private static final int COL = 8;
	public int you = 1;
	public int me = 2;
	public int[][] data;
	public int black_num, white_num;

	public ReversiObject() {
		super();
		data = new int[COL][ROW];
		init();
	}

	public void init() {
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				data[i][j] = 0;
			}
		}
		data[3][3] = 1;
		data[3][4] = 2;
		data[4][3] = 2;
		data[4][4] = 1;
	}

	public void setPiece(int c, int r, int side) {
		data[c][r] = side;
	}

	public int getPieces(int[][] data0, int x1, int y1, int side) {
		int num = 0;
		int[] dt = { 0, -1, 1 };
		for (int dx : dt) {
			for (int dy : dt) {
				int xn = x1;
				int yn = y1;
				boolean f = false;
				int nn = 0;
				while (true) {
					xn += dx;
					yn += dy;
					f = true;
					if ((xn == x1) && (yn == y1)) {
						f = false;
						break;
					}
					if ((xn < 0) || (xn > 7) || (yn < 0) || (yn > 7)) {
						f = false;
						break;
					}
					if (data0[xn][yn] == 0) {
						f = false;
						break;
					}
					if (data0[xn][yn] == side) {
						f = true;
						break;
					}
					++nn;
				}
				if (f)
					num += nn;
			}
		}
		return num;
	}

	public int[][] reversePieces(int[][] data2, int x1, int y1, int side) {
		int[] dt = { 0, -1, 1 };
		for (int dx : dt) {
			for (int dy : dt) {
				int xn = x1;
				int yn = y1;
				boolean f = false;
				while (true) {
					xn = xn + dx;
					yn = yn + dy;
					if ((xn < 0) || (xn > 7) || (yn < 0) || (yn > 7)) {
						f = false;
						break;
					}
					if (data2[xn][yn] == 0) {
						f = false;
						break;
					}
					if (data2[xn][yn] == side)
						break;
					f = true;
				}
				if (f) {
					xn = x1;
					yn = y1;
					while (true) {
						xn = xn + dx;
						yn = yn + dy;
						if (data2[xn][yn] == side)
							break;
						data2[xn][yn] = side;
					}
				}
			}
		}
		return data2;
	}

	public void countData() {
		black_num = 0;
		white_num = 0;
		for (int i = 0; i < 8; i++) {
			for (int j = 0; j < 8; j++) {
				if (data[i][j] == 1)
					black_num++;
				if (data[i][j] == 2)
					white_num++;
			}
		}
	}

}
