package jp.rutles.sample;

import java.util.List;
import java.util.concurrent.*;

import android.app.Activity;
import android.content.Context;
import android.graphics.*;
import android.graphics.Paint.Style;
import android.hardware.*;
import android.util.AttributeSet;
import android.view.*;

public class SampleView extends SurfaceView
		implements SensorEventListener,SurfaceHolder.Callback {
	private Activity context;
	private SurfaceHolder holder;
	private float[][] data;
	private float x = 100;
	private float y = 100;

	public SampleView(Context context) {
		super(context);
		init(context);
	}
	
	public SampleView(Context context, AttributeSet attrs) {
		super(context, attrs);
		init(context);
	}
	
	public void init(Context context){
		this.context = (Activity)context;
		holder = getHolder();		
		holder.addCallback(this);
		setFocusable(true);
		requestFocus();
		data = new float[25][2];
		for (int i = 0;i < data.length;i++){
			data[i][0] = 100;
			data[i][1] = 100;
		}
	}
	
	public void setAllData(int x, int y){
		for (int i = 0;i < data.length;i++){
			data[i][0] = x;
			data[i][1] = y;
		}
	}
	
	public void start(){
		SensorManager manager = (SensorManager)context.
				getSystemService(Activity.SENSOR_SERVICE);
		List<Sensor> sensors = manager.
				getSensorList(Sensor.TYPE_ACCELEROMETER);
		if (sensors.size() > 0) {
			Sensor sensor = sensors.get(0);
			manager.registerListener(this, sensor,
					SensorManager.SENSOR_DELAY_FASTEST);
		}
		ScheduledExecutorService executor =
				Executors.newSingleThreadScheduledExecutor();
		executor.scheduleAtFixedRate(new Runnable() {
			@Override
			public void run() {
					addPoint(x,y);
					draw();
			}
		}, 100, 100, TimeUnit.MILLISECONDS);				
	}
	
	@Override
	public void surfaceChanged(SurfaceHolder holder,
			int format, int width, int height) {}

	@Override
	public void surfaceCreated(SurfaceHolder holder) {
		draw();
		start();
	}

	@Override
	public void surfaceDestroyed(SurfaceHolder holder) {}

	public void addPoint(float x,float y){
		for (int i = data.length - 2;i >= 0;i--) {
			data[i + 1][0] = data[i][0];
			data[i + 1][1] = data[i][1];
		}
		data[0][0] = x;
		data[0][1] = y;
	}
	
	public void draw(){
		Canvas c = holder.lockCanvas();
		c.drawColor(Color.WHITE);
		Paint p = new Paint();
		p.setStyle(Style.FILL);
		p.setColor(Color.RED);
		for (int i = 0;i < data.length;i++){
			p.setAlpha(255 - i * 10);
			float x = data[i][0];
			float y = data[i][1];
			RectF r = new RectF(x - 50,y - 50,x + 50,y + 50);
			c.drawArc(r, 0f, 360f, true, p);
		}
		holder.unlockCanvasAndPost(c);
	}

	@Override
	public void onAccuracyChanged(Sensor sensor, int accuracy) {}

	@Override
	public void onSensorChanged(SensorEvent event) {
		if (event.sensor.getType() == Sensor.TYPE_ACCELEROMETER) {
			this.x -= event.values[0];
			this.y += event.values[1];
		}
	}
}
