package jp.rutles.throwing;

import android.graphics.*;
import android.graphics.drawable.Drawable;

public class Enemies {
	private static final int COL = 5; // ̐
	private static final int ROW = 5; // c̐
	private static final int HIT_DATA = -1; // qbgԍ
	private static final int NO_DATA = -5; // \ȂԂԍ
	private float enemy_x = 500; // ʒu
	private float enemy_y = 50; // cʒu
	private float enemy_w = 50; // 
	private float enemy_h = 50; // c
	private float space_w = 80; // eGL̊Ԋuij
	private float space_h = 70; // eGL̊Ԋuicj
	private int[][] datas; // \DrawableǗQz
	private Drawable[] imgs; // \pDrawableǗz
	private Drawable bang_img; // Փ˂̃OtBbN

	public Enemies(Drawable[] imgs, Drawable bang_img,
			float x, float y) {
		this.imgs = imgs;
		this.bang_img = bang_img;
		datas = new int[COL][ROW];
		enemy_x = x;
		enemy_y = y;
	}

	public void init() {
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				datas[i][j] = 0;
			}
		}
	}

	public void move() {
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				if (datas[i][j] >= 0)
					datas[i][j] = (datas[i][j] + 1) % 4;
			}
		}
	}

	public int checkHit(Point p) {
		int count = 0;
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				if (datas[i][j] < 0)
					continue;
				float x1 = enemy_x + space_w * i;
				float y1 = enemy_y + space_h * j;
				float x2 = x1 + enemy_w;
				float y2 = y1 + enemy_h;
				if (p.x > x1 && p.x < x2 && p.y > y1 && p.y < y2) {
					datas[i][j] = HIT_DATA;
					count++;
				}
			}
		}
		return count;
	}

	public boolean isFinished() {
		boolean f = true;
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				if (datas[i][j] >= 0) f = false;
			}
		}
		return f;
	}

	public void draw(Canvas canvas) {
		for (int i = 0; i < COL; i++) {
			for (int j = 0; j < ROW; j++) {
				int n = datas[i][j];
				Rect r = new Rect((int) (enemy_x + space_w * i),
						(int) (enemy_y + space_h * j), (int) (enemy_x + space_w
								* i + enemy_w),
						(int) (enemy_y + space_h * j + enemy_h));
				if (n >= 0) {
					imgs[n].setBounds(r);
					imgs[n].draw(canvas);
				} else if (n < 0) {
					if (n != NO_DATA) {
						datas[i][j] -= 1;
						bang_img.setBounds(r);
						bang_img.draw(canvas);
					}
				}
			}
		}
	}
}
